'=============================================================
'                      Terms of License
' -----------------------------------------------------------
' Terminabrechnung  2024 by Jens-Christian Wawrczeck
' is licensed under *CC BY-SA 4.0*
' (Creative Commons Attribution-ShareAlike 4.0 International)
' -----------------------------------------------------------
' To view a copy of this license, visit
' https://creativecommons.org/licenses/by-sa/4.0/
'=============================================================

Option Compare Database
Option Explicit

Private Sub Button_NeuerPreis_Click()
On Error GoTo Err_Button_NeuerPreis_Click

    Dim stDocName As String
    Dim stLinkCriteria As String
    
    'Falls "Preis je Kategorie" ausgewhlt ist, aber keine Kategorie dazu (bzw. es keine Kategorien gibt),
    'dies abfangen:
    '(ebenso mit Kalender)
    If (AktKategorie = 0) Then
        If ((FormularName = "Einstellungen_2") And (RePreisJeKategorie = True)) _
                Or ((FormularName = "Kunden") And (ReKundePreisJeKategorie = True)) Then
            MsgBox "Bitte whlen Sie zuerst eine gltige Kategorie aus.", vbInformation + vbOKOnly, "Hinweis"
            Exit Sub
        End If
    End If
    If (AktKalender = 0) Then
        If ((FormularName = "Einstellungen_2") And (RePreisJeKalender = True)) _
                Or ((FormularName = "Kunden") And (ReKundePreisJeKalender = True)) Then
            MsgBox "Bitte whlen Sie zuerst einen gltigen Kalender aus.", vbInformation + vbOKOnly, "Hinweis"
            Exit Sub
        End If
    End If

    stDocName = "Gebhr_neu"
    DoCmd.OpenForm stDocName, , , stLinkCriteria
    
    Me.Requery
    Me.Repaint

Exit_Button_NeuerPreis_Click:
    Exit Sub

Err_Button_NeuerPreis_Click:
    MsgBox err.Description
    Resume Exit_Button_NeuerPreis_Click

End Sub

Private Sub Button_PreisLoeschen_Click()
    On Error GoTo ERROR_Button_PreisLoeschen_Click

    Dim dbs As Database
    Dim rst As Recordset
    Dim strFilter As String
    
    'Eigenen Formularnamen merken fr Aktualisierung
    FormularName = "Einstellungen_2"
''    FormularBereich = "Gebuehren"
    
    'Tabelle ffnen
    Set dbs = CurrentDb
    Set rst = Me.RecordsetClone
    
    'wenn Datensatz vorhanden, dann lschen...
    If (rst.RecordCount = 0) Then
        Set dbs = Nothing
        MsgBox "Keine Preise vorhanden.", vbInformation, "Hinweis"
    Else
        strFilter = "SELECT * FROM Preise WHERE [lfd_Nr] = " & AktGebuehr_allg
        Set rst = dbs.OpenRecordset(strFilter)
        If MsgBox("Ausgewhlten Preis [ab " & rst!gilt_ab & " = " & Format(rst!Std_Satz, "Currency") & "] wirklich lschen?", vbYesNo + vbQuestion + vbDefaultButton2, "Preis lschen...") = vbNo Then
            rst.Close
            Set dbs = Nothing
            Exit Sub
        End If
        rst.Delete
        rst.Requery
        rst.Close
        Set dbs = Nothing
        
        'Anzeige aktualisieren
        Me.Requery
        
    End If
    
EXIT_Button_PreisLoeschen_Click:
    Exit Sub
    
ERROR_Button_PreisLoeschen_Click:
    MsgBox err.Description
    Resume EXIT_Button_PreisLoeschen_Click

End Sub

Private Sub Form_Current()
    'merken fr Bearbeitung
    AktGebuehr_allg = Me.lfd_Nr.Value
End Sub

Private Sub Form_Open(Cancel As Integer)
    'aktuelles Whrungsformat des Systems einstellen
    Me.Std_Satz.Format = "Currency"
End Sub
